<?php
/* --------------------------------------------------------------
   ImageProcessingServiceProvider.php 2022-12-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing;

use Gambio\Admin\Modules\ImageProcessing\App\Creation\ImageProcessingConfigurationFactory;
use Gambio\Admin\Modules\ImageProcessing\App\Data\Gd\ProcessedImageInformationRepository;
use Gambio\Admin\Modules\ImageProcessing\App\Data\ImageProcessingConfigurationRepository;
use Gambio\Admin\Modules\ImageProcessing\App\ImageProcessingGdService;
use Gambio\Admin\Modules\ImageProcessing\App\Processor\GDImageProcessor;
use Gambio\Admin\Modules\ImageProcessing\Service\ImageProcessingService;
use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Configuration\Services\ConfigurationFinder;

/**
 * Class ImageProcessingServiceProvider
 *
 * @package Gambio\Admin\Modules\ImageProcessing
 */
class ImageProcessingServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            //ImageProcessingOverview::class,
            
            ImageProcessingService::class,
            ImageProcessingConfigurationRepository::class, // Todo: for testing only
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        //$this->application->registerShared(ImageProcessingOverview::class);
        
        $this->registerService();
        $this->registerComponents();
    }
    
    
    private function registerService(): void
    {
        $this->application->registerShared(ImageProcessingService::class, ImageProcessingGdService::class)
            ->addArgument(GDImageProcessor::class)
            ->addArgument(ImageProcessingConfigurationRepository::class)
            ->addArgument(Path::class);
    }
    
    
    private function registerComponents(): void
    {
        $this->application->registerShared(ImageProcessingConfigurationRepository::class)
            ->addArgument(ImageProcessingConfigurationFactory::class)
            ->addArgument(ConfigurationFinder::class)
            ->addArgument(Path::class);
        $this->application->registerShared(ImageProcessingConfigurationFactory::class);
        $this->application->registerShared(GDImageProcessor::class)
            ->addArgument(ProcessedImageInformationRepository::class);
        $this->application->registerShared(ProcessedImageInformationRepository::class);
    }
}